from openquake.srtk.response.amplification import sh_transfer_function

import matplotlib.pyplot as plt
import numpy as np

hl = np.array([100.,0])
vs = np.array([200.,1200.])
dn = np.array([1900., 2500.])
qs = np.array([10.,100.])

#freq = np.logspace(np.log10(0.1), np.log10(100.), 1000)
freq = np.arange(0., 10., 0.01)

dis = sh_transfer_function(freq, hl, vs, dn, qs, inc_ang=0.)

omega = 2.*np.pi*freq
vsq = vs*((2.*qs*1j)/(2.*qs*1j-1.))
an_amp = 1./np.abs(np.cos(omega*hl[0]/vsq[0]))

plt.figure()
#plt.plot(freq, an_amp, 'k')

for nl in range(len(hl)):

    amp = np.abs(dis[nl]/2.)

    plt.plot(freq, amp)

plt.show(block=False)