from openquake.srtk.response.amplification import sh_transfer_function
from openquake.srtk.response.amplification import interface_depth

import matplotlib.pyplot as plt
import numpy as np

hl = np.array([10.,50.,0])
vs = np.array([200.,500.,1200.])
dn = np.array([1900.,2100., 2500.])
qs = np.array([10.,20.,100.])

#freq = np.logspace(np.log10(0.1), np.log10(100.), 1000)
freq = np.arange(0., 10., 0.01)

depth = np.linspace(0., 100., 100)
depth = [0., 10., 60.]
#depth = -1

dis = sh_transfer_function(freq, hl, vs, dn, qs, inc_ang=0., depth=depth)

if isinstance(depth, (int, float)):
    depth = interface_depth(hl)

plt.figure()
for nz in range(len(depth)):
    amp = np.abs(dis[nz]/2.)
    plt.plot(freq, amp)
plt.show(block=False)

plt.figure(figsize=(3,6))
for nz in range(len(depth)):
    amp = np.abs(dis[nz][500]/2.)
    plt.plot(amp, depth[nz],'k.')
plt.gca().invert_yaxis()
plt.show(block=False)