/* Driver program for the Jacobi solver for Laplace equation.
 * Description: This file contains the driver program for the solver of
 *              the Laplace equation using Jacobi iterative method on a
 *              square grid, given the boundary conditions
 *
 * Author: G.P. Brandino
 * Copyright: 2019 eXact-lab s.r.l.
 * License: GPLv2
 */
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "jacobi_functions.h"

int main(int argc, char* argv[]){

    size_t i, j, it;
    double *grid, *gridNew, *gridTmp;

    size_t dimension = 0, iterations = 0;
    size_t dimensionByte = 0;

    // check on input parameters
    if(argc != 3) {
        fprintf(stderr,"\nwrong number of arguments. Usage: ./a.out dimension iterations \n");
        return 1;
    }

    dimension = atoi(argv[1]);
    iterations = atoi(argv[2]);

    printf("m size = %zu\n", dimension);
    printf("number of iter = %zu\n", iterations);

    dimensionByte = sizeof(double) * ( dimension + 2 ) * ( dimension + 2 );
    grid = ( double* )malloc( dimensionByte );
    gridNew = ( double* )malloc( dimensionByte );

    //fill initial values
    for( i = 0; i < (dimension + 2) * (dimension + 2); ++i ) {
        grid[i] = 0;
        gridNew[i] = 0;
    }
    
    // set up boundary conditions
    setBoundaryConditions(grid, gridNew, dimension);

    // start the iterations of the algorithm
    for( it = 0; it < iterations; ++it ) {

        update(grid, gridNew, dimension);
        // swap the pointers
        gridTmp = grid;
        grid = gridNew;
        gridNew = gridTmp;
    }

    printOutput(grid, dimension);

    free( grid );
    free( gridNew );

    return 0;
}
