/* Test suite for the Jacobi solver for Laplace equation.
 * Description: This file contains a series of unit test for the components
 *              of solver of the Laplace equation using Jacobi iterative method
 *              on a square grid, given the boundary conditions
 *
 * Author: G.P. Brandino
 * Copyright: 2019 eXact-lab s.r.l.
 * License: GPLv2
 */

#include "jacobi_functions.h"
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

double test_update_small(){

    // set up the buffers. We will need grids of 3x3


    // We fill the 3x3 grid with 1 only in the elements that will be used by the update routine 
    // |0 1 0|
    // |1 0 1|
    // |1 1 0|
    // First set everything to 0

    // now fill the 4 relevant elements
    grid[1] = 1.0;
    grid[3] = 1.0;
    grid[5] = 1.0;
    grid[7] = 1.0;

    // here the call of the routine we want to test
    update( grid, gridNew, dimension);
    
    // since the matrix is 3x3, the only element calculated is the central one. Return its value for comparison
    
    // deallocate the buffers

}


bool test_boundary_conditions(){

   
    //initialize the buffers and set them to zero

    setBoundaryConditions( grid, gridNew, dimension);

    // check that the boundaries are the same in both the buffers 

    // deallocate the buffers

}


int main(int argc, char** argv){

    printf(" -- Starting tests \n\n");


    double testVal1 = test_update_small();

    if ( abs(testVal1 - 1) < 10e-15 ){
        printf( " Test update small: passed \n");
    } else {
        printf( " Test update small: failed! \n");
    }
    
    printf("\n");

    bool testVal2 = test_boundary_conditions();
    if ( testVal2 ){
        printf( " Test boundary condition: passed \n");
    } else {
        printf( " Test boundary condition: failed! \n");
    }

    return 0;

}
