/* This file is a part of the Jacobi solver for Laplace equation.
 * Description: This file provides several routines for the solver of the
 *              Laplace equation using Jacobi iterative method on a square grid,
 *              given the boundary conditions
 *
 * Author: G.P. Brandino
 * Copyright: 2019 eXact-lab s.r.l.
 * License: GPLv2
 */

#include <stdio.h>

void setBoundaryConditions(double* grid, double* gridNew, int dimension){
    // Note that the borders are never modified by the update, so we need to
    // set up b.c. on BOTH the buffers
    int i;
    double increment = 100.0 / ( dimension + 1 );

    for( i=1; i <= dimension + 1; ++i ) {
        grid[ i * ( dimension + 2 ) ] = i * increment;
        grid[ ( ( dimension + 1 ) * ( dimension + 2 ) ) + ( dimension + 1 - i ) ] = i * increment;
        gridNew[ i * ( dimension + 2 ) ] = i * increment;
        gridNew[ ( ( dimension + 1 ) * ( dimension + 2 ) ) + ( dimension + 1 - i ) ] = i * increment;
    }

/*    for ( i = 0; i <= dimension + 1; i++){
      grid[ i * ( dimension + 2 ) ] = 100.0;
      grid[ i * ( dimension + 2 ) + dimension + 1] = 100;
      grid[ i ] = 100;
      grid[ ( ( dimension + 1 ) * ( dimension + 2 ) ) + i ] = 100;
 
      gridNew[ i * ( dimension + 2 ) ] = 100.0;
      gridNew[ i * ( dimension + 2 ) + dimension + 1] = 100;
      gridNew[ i ] = 100;
      gridNew[ ( ( dimension + 1 ) * ( dimension + 2 ) ) + i ] = 100;

    }*/


/*    for ( i = 0; i <= dimension + 1; i++){
      grid[ i * ( dimension ) ] = 100.0;
      grid[ i * ( dimension ) + dimension + 1] = 100;
      grid[ i ] = 100;
      grid[ ( ( dimension + 1 ) * ( dimension ) ) + i ] = 100;
      gridNew[ i * ( dimension ) ] = 100.0;
      gridNew[ i * ( dimension ) + dimension + 1] = 100;
      gridNew[ i ] = 100;
      gridNew[ ( ( dimension + 1 ) * ( dimension ) ) + i ] = 100;
    
      
    } */
}


void update(double* grid, double* gridNew, int dimension){

  int i,j;
  for( i = 1 ; i <= dimension; ++i ) {
      for( j = 1; j <= dimension; ++j ) {
          gridNew[ ( i * ( dimension + 2 ) ) + j ] = 0.25 *
          ( grid[ ( ( i - 1 ) * ( dimension + 2 ) ) + j ]
          + grid[ ( i * ( dimension + 2 ) ) + ( j + 1 ) ]
          + grid[ ( ( i + 1 ) * ( dimension + 2 ) ) + j ]
          + grid[ ( i * ( dimension + 2 ) ) + ( j - 1 ) ] );
      }
  }
}

void printOutput(double* grid, int dimension) {

  int i,j;
  FILE *file;
  file = fopen( "solution.dat", "w+" );

  for( i = 0; i < dimension + 2; ++i ){
      for( j = 0; j < dimension + 2; ++j ){
          fprintf(file, "%f ", grid[ ( i * ( dimension + 2 ) ) + j ] );
      }
      fprintf(file, "\n");
  }

  fclose( file );
}
