# This file is a part of the Jacobi solver for Laplace equation.
# Description: This file provides unit test for the components of the solver of
#              Laplace equation using Jacobi iterative method on a square grid,
#              given the boundary conditions
#
# Author: G.P. Brandino
# Copyright: 2019 eXact-lab s.r.l.
# License: GPLv2
#
import jacobi_functions as jacobi
import unittest
import filecmp

class TestMethods(unittest.TestCase):
    def test_update_small(self):

        # set up the buffers. We will need grids of 3x3


        # We fill the 3x3 grid with 1 only in the elements that will be used by the update routine 
        # |0 1 0|
        # |1 0 1|
        # |1 1 0|
        # First set everything to 0


        # now fill the 4 relevant elements

        jacobi.update(grid, gridNew, dimension)

        # since the matrix is 3x3, the only element calculated is the central one
        # use self.assetEqual method to verify



    def test_boundary_conditions(self):
        #initialize the buffers and set them to zero
            
        jacobi.setBoundaryConditions(grid, gridNew, dimension)
        
        # check that the boundaries are the same in both the buffers 

        
        # you can for example use self.assertTrue() on a control variable to verify they are the same

    def test_integration(self):
        
        dimension = 10
        iterations = 5
        grid  = [[0 for x in range(dimension + 2)] for y in range(dimension + 2)] 
        gridNew = [[0 for x in range(dimension + 2)] for y in range(dimension + 2)] 
        jacobi.setBoundaryConditions(grid, gridNew, dimension)
        for it in range(iterations):
            jacobi.update(grid, gridNew, dimension)
            #we use list to force a deep copy, otherwise for lists only the reference is copied        
            grid = list(gridNew)

        jacobi.printOutput(grid, dimension)
        equal =  filecmp.cmp('solution.dat', 'solution_test.dat')
        self.assertTrue(equal)


if __name__ == "__main__":
    unittest.main()
