/* This file is a part of the Jacobi solver for Laplace equation.
 * Description: This file provides several routines for the solver of the
 *              Laplace equation using Jacobi iterative method on a square grid,
 *              given the boundary conditions
 *
 * Author: G.P. Brandino
 * Copyright: 2019 eXact-lab s.r.l.
 * License: GPLv2
 */
#ifndef H_JACOBI_FUNCTIONS
#define H_JACOBI_FUNCTIONS
void setBoundaryConditions(double* grid, double* gridNew, int dimension);

void update(double* grid, double* gridNew, int dimension);

void printOutput(double* grid, int dimension);
#endif
