/** \file jacobi_functions.h
 *  \brief This file is a part of the Jacobi solver for Laplace equation.
 *  \details This file provides several routines for the solver of the
 *              Laplace equation using Jacobi iterative method on a square grid,
 *              given the boundary conditions  
 *
 * \author Giuseppe Piero Brandino - eXact-lab s.r.l.
 * \copyright 2019 eXact-lab s.r.l. - GPLv2
 */
#ifndef H_JACOBI_FUNCTIONS
#define H_JACOBI_FUNCTIONS

/** Sets the boundary conditions on both the grid buffers
 * \param[in] grid double precision array containing the first grid buffer
 * \param[in] gridNew double precision array containing the second grid buffer
 * \param[in] dimension the size of the system. The buffers should be of size (dimension + 2)^2
 */
void setBoundaryConditions(double* grid, double* gridNew, int dimension);

/** Performs one step of the Jacobi iteravite process
 * \param[in] grid double precision array containing the first grid buffer
 * \param[in] gridNew double precision array containing the second grid buffer
 * \param[in] dimension the size of the system. The buffers should be of size (dimension + 2)^2
 */
void update(double* grid, double* gridNew, int dimension);

/** Prints the output in text format
 * \param[in] grid double precision array containing the first grid buffer
 * \param[in] dimension the size of the system. The buffers should be of size (dimension + 2)^2
 */
void printOutput(double* grid, int dimension);
#endif
