/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-02-05
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ARRAYPROCESS_H
#define ARRAYPROCESS_H

#include "ArrayStations.h"
#include "ArrayParameters.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

class ARRAYCORE_EXPORT ArrayProcess : public AbstractParameters
{
  TRANSLATIONS("ArrayProcess")
public:
  virtual ~ArrayProcess();

  const ArrayParameters * takeParameters();

  void setHorizontalDirection( double az ) { _horizontalDirection = az; }

  bool setFrequency( double f, QString * log = 0 );
  bool setFrequency( int iOmega, QString * log = 0, QString * status = 0 );

  void setTimeRangeList(TimeRangeList * rl) {_timeRangeList=rl;}
  TimeRangeList * timeRangeList() {return _timeRangeList;}
  const TimeRangeList * timeRangeList() const {return _timeRangeList;}

  const ArrayParameters * parameters() const { return _parameters; }
  const FrequencyBand& frequency() const { return _frequency; }
  const QList<StationProcessSignals *>& stations() const { return _stations; }

  bool lockTimeWindow( const TimeRange * win );
  void unlockTimeWindow();
protected:
  ArrayProcess();
  bool setParameters( const ArrayParameters * param, bool doNSampleWarning = true );

  QList<StationProcessSignals *> _stations;
  double _horizontalDirection;
private:
  bool setTimeLimits(bool doNSampleWarning);
  void setGlobalKeep();

  const ArrayParameters * _parameters;

  FrequencyBand _frequency;
  SparseKeepSignal * _keep;
  TimeRangeList * _timeRangeList;

  bool _signalsLocked;
};

} // namespace ArrayCore

#endif // ARRAYPROCESS_H
