/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-03-23
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ARRAYSTATIONS_H
#define ARRAYSTATIONS_H

#include <GeopsyCore.h>

#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

class ARRAYCORE_EXPORT ArrayStations : public StationList
{
  TRANSLATIONS("ArrayStations")
public:
  ArrayStations();
  ~ArrayStations();

  bool hasCompatibleStations( QString * log = 0 ) const;

  Rect rectangle() const;
  void setRelativeCoordinates();
  const Point2D& relativeCoordinates(int station) const { ASSERT(station<count()); return _relativeCoordinates[station]; }
private:
  Point2D * _relativeCoordinates;
};

} // namespace ArrayCore

#endif // ARRAYSTATIONS_H
