/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-11-12
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef FK_H
#define FK_H

#include <QGpCoreTools.h>
#include "FrequencyBand.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

class FKStationSignals;

class ARRAYCORE_EXPORT FK : public AbstractFunction2
{
public:
  FK( QList<FKStationSignals *> array );
  ~FK() { delete [] _gaussian; }

  void setMaximumSlowness(double slow) { _squaredSlowMax = slow*slow; }
  double maximumSlowness() const { return sqrt(_squaredSlowMax); }

  void setMaximumWavenumber(double k) { _squaredKmaxGrid = k*k; }
  void setFrequencyBand(const FrequencyBand& f, double windowLength);

  virtual void initGrid(int n);
  virtual void initGrid(double kx, double ky, int index);
  virtual double value(double kx, double ky) const;
  virtual double value(double kx, double ky, int index) const;
  double absolutePower( int iComp ) const;
protected:
  double maximumK2() const { return _squaredKmaxTotal; }

  QList<FKStationSignals *> _array;
  // Index range for frequencies
  int _iFreqMin, _iFreqMax;
  // Stored only for warning messages
  double _frequency;
  double * _gaussian, * _gaussianPtr;
private:
  // Maximum K^2 from grid limits
  double _squaredKmaxGrid;
  // Maximum slowness^2
  double _squaredSlowMax;
  // Maximum K^2 from grid limits and maximum slowness
  double _squaredKmaxTotal;
};

} // namespace ArrayCore

#endif // FK_H
