/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-03-23
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef FKARRAYPROCESS_H
#define FKARRAYPROCESS_H

#include "ArrayProcess.h"
#include "FKParameters.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

class FK;

class ARRAYCORE_EXPORT FKArrayProcess : public ArrayProcess
{
public:
  FKArrayProcess(const ArrayStations& array);

  virtual FK * function(int iComp);

  inline bool setParameters( const FKParameters * param, bool doNSampleWarning = true );
  inline const FKParameters * parameters() const;
};

inline const FKParameters * FKArrayProcess::parameters() const
{
  return static_cast<const FKParameters *>(ArrayProcess::parameters());
}

inline bool FKArrayProcess::setParameters( const FKParameters * param, bool doNSampleWarning )
{
  return ArrayProcess::setParameters(param, doNSampleWarning);
}

} // namespace ArrayCore

#endif // FKARRAYPROCESS_H
