/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2004-08-23
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef FKGridSearch_H
#define FKGridSearch_H

#include <QGpCoreTools.h>
#include "FK.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

class ARRAYCORE_EXPORT FKGridSearch :  public GridSearch
{
public:
  FKGridSearch();

  inline void setGrid( double kmin, double kmax );

  void setFunction( FK * f ) { _function = f; }
  FK * function() const { return static_cast<FK *>(_function); }
};

inline void FKGridSearch::setGrid( double kmin, double kmax )
{
  TRACE;
  GridSearch::setGrid( -kmax, kmax, kmin, -kmax, kmax, kmin );
}

} // namespace ArrayCore

#endif // FKGRIDSEARCH_H
