/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-11-27
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef FKHORIZONTAL_H
#define FKHORIZONTAL_H

#include <QGpCoreTools.h>
#include "FK.h"

namespace ArrayCore {

class FKHorizontal : public FK
{
protected:
  FKHorizontal( QList<FKStationSignals *> array );
public:
  FKHorizontal( double angle, QList<FKStationSignals *> array );
  ~FKHorizontal();

  virtual void initGrid(int n);
  virtual void initGrid(double kx, double ky, int index);
  virtual double value(double kx, double ky) const;
  virtual double value(double kx, double ky, int index) const;
  virtual Point2D rotationFactors(double kx, double ky) const { Q_UNUSED(kx); Q_UNUSED(ky); return _fixedRotation; }
protected:
  int _northIndex, _eastIndex;
  Point2D * _rotation;
private:
  void setComponents( int nComponent );
  Point2D _fixedRotation;
};

} // namespace ArrayCore

#endif // FKHORIZONTAL_H
