/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-02-06
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef FKPARAMETERS_H
#define FKPARAMETERS_H

#include "ArrayParameters.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

class ARRAYCORE_EXPORT FKParameters : public ArrayParameters
{
public:
  FKParameters();

  double minimumWaveNumber() const { return _kmin; }
  void setMinimumWaveNumber( double k ) { _kmin = k; }

  double maximumWaveNumber() const { return _kmax; }
  void setMaximumWaveNumber( double k ) { _kmax = k; }

  double maximumSlowness() const { return _smax; }
  void setMaximumSlowness( double s ) { _smax = s; }

  int maximumPeakCount() const { return _maxPeakCount; }
  void setMaximumPeakCount( int m ) { _maxPeakCount = m; }

  double absoluteThreshold() const { return _absoluteThreshold; }
  void setAbsoluteThreshold( double a ) { _absoluteThreshold = a; }

  double relativeThreshold() const { return _relativeThreshold; }
  void setRelativeThreshold( double r ) { _relativeThreshold = r; }

  bool exportAllFKGrids() const { return _exportAllFKGrids; }
  void setExportAllFKGrids( bool g ) { _exportAllFKGrids = g; }
private:
  double _kmin, _kmax, _smax;
  int _maxPeakCount;
  double _absoluteThreshold, _relativeThreshold;
  bool _exportAllFKGrids;
};

} // namespace ArrayCore

#endif // FKPARAMETERS_H
