/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2004-06-21
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef FKStationSignals_H
#define FKStationSignals_H

#include <GeopsyCore.h>

#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

class ARRAYCORE_EXPORT FKStationSignals : public StationProcessSignals
{
public:
  FKStationSignals( const StationSignals * originalSignals );
  ~FKStationSignals();

  virtual void setProcessed( const TimeRange& tw, AbstractParameters * param );

  void setRelativeCoordinates( const Point2D& p ) { _relativeCoordinates = p; }
  void initPhaseShifts( int n );
  void setPhaseShift(int index, double kx, double ky);

  double absolutePower( int iComp, int iFreqMin, int iFreqMax, double * taperingFunction );
  inline void setCurrentShift( double kx, double ky );

  inline Complex getShiftedSignal( int component, int iFreq, int offset );
  inline Complex getShiftedSignal( int component, int iFreq );
  inline Complex getSignalSpectrum( int component, int iFreq );
  inline Complex& getShift( int offset ) { return _shift[ offset ]; }
  inline Complex& getShift() { return _currentShift; }

  bool isSelected() const { return _selected; }
  void select( bool s ) { _selected = s; }
protected:
  Complex * _shift;
  Complex _currentShift;
  Point2D _relativeCoordinates;
  bool _selected;
};

inline Complex FKStationSignals::getShiftedSignal( int component, int iFreq, int offset )
{
  Complex spec( processed(component)->complex( processedSamples(component), iFreq ) );
  spec *= _shift[ offset ];
  return spec;
}

inline Complex FKStationSignals::getShiftedSignal( int component, int iFreq )
{
  Complex spec( processed(component)->complex( processedSamples(component), iFreq ) );
  spec *= _currentShift;
  return spec;
}

inline Complex FKStationSignals::getSignalSpectrum( int component, int iFreq )
{
  return Complex( processed(component)->complex( processedSamples(component), iFreq ) );
}

inline void FKStationSignals::setCurrentShift( double kx, double ky )
{
  _currentShift.setUnitExp( kx * _relativeCoordinates.x() + ky * _relativeCoordinates.y() );
}

} // namespace ArrayCore

#endif // FKSTATIONSIGNALS_H
