/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-11-12
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef FREQUENCYBAND_H
#define FREQUENCYBAND_H

#include <QGpCoreTools.h>
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

class ARRAYCORE_EXPORT FrequencyBand
{
public:
  FrequencyBand();
  FrequencyBand( const FrequencyBand& o );

  inline void setCenter( double f );
  void setRelativeWidth( double w ) { _relativeWidth = w; }
  double center() const { return _center; }
  double omega() const { return _omega; }
  double relativeWidth() const { return _relativeWidth; }
  double width() const { return 2.0 * _relativeWidth * _center; }
  double halfWidth() const { return _relativeWidth * _center; }
  double lowLimit() const { return _center * ( 1.0 - _relativeWidth ); }
  double highLimit() const { return _center * ( 1.0 + _relativeWidth ); }
private:
  double _center;
  double _relativeWidth;
  double _omega;
};

inline void FrequencyBand::setCenter( double f )
{
  TRACE;
  _center = f;
  _omega = 2.0 * M_PI * _center;
}

} // namespace ArrayCore

#endif // FREQUENCYBAND_H
