/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-11-12
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef HRFK_H
#define HRFK_H

#include <QGpCoreTools.h>
#include "FK.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

class ARRAYCORE_EXPORT HRFK : public FK
{
  TRANSLATIONS("HRFK")
public:
  HRFK( QList<FKStationSignals *> array );
  ~HRFK();

  Complex * crossCorrelationMatrix( int component );
  Complex * crossCorrelationMatrix( double angle );
  void initOperator( Complex * covmat, double dampingFactor, QString * log=0 );

  virtual double value(double x, double y) const;
  virtual double value(double x, double y, int index) const;
private:
  void initOperatorError( const QString& msg, QString * log=0 );

  int _northIndex, _eastIndex;
  Complex * _Rmatrix;
  int _selectedStationCount;
  int * _stationIndexes;
};

} // namespace ArrayCore

#endif // HRFK_H
