/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-11-12
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef KMAXSOLVER_H
#define KMAXSOLVER_H

#include <QGpCoreTools.h>
#include <QGpCoreWave.h>

#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

class ARRAYCORE_EXPORT KmaxSolver: public Thread, public TheoreticalLinearFK, private ConcentricSearch
{
  Q_OBJECT
public:
  KmaxSolver(const QVector<Point2D>& stations, double kmin);
  ~KmaxSolver();

  void calculate() {start();}
  void terminate();

  double kmax(bool& ok) const;
private:
  virtual void run();

  QAtomicInt _terminated;
  mutable QMutex _kMutex;
  double _kminHalf;
  double _dk;
  double _kmax;
  bool _valid;
};

} // namespace ArrayCore

#endif // KMAXSOLVER_H
