/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2004-01-05
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef RINGCOUPLES_H
#define RINGCOUPLES_H

#include <GeopsyCore.h>
#include <QGpCoreWave.h>

#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

class StationCouple;

class ARRAYCORE_EXPORT RingCouples: public QVector<const StationCouple *>, public AutocorrRing
{
public:
  RingCouples() : AutocorrRing() { _weights=0; }
  RingCouples( double rMin, double rMax ) : AutocorrRing(rMin, rMax) { _weights=0; }
  RingCouples( const RingCouples& o );
  ~RingCouples() { delete [] _weights; }

  void operator=( const RingCouples& o );

  bool setCouples( const QVector<StationCouple>& couples );
  QString log() const;
  QString name() const { return QString( "(%1 m, %2 m)" ).arg( minRadius() ).arg( maxRadius() );}
  double weight(int index) const { return _weights[index]; }
private:
  static bool lessThan(const StationCouple * s1, const StationCouple * s2);

  double * _weights;
};

} // namespace ArrayCore

#endif // RINGCOUPLES_H
