/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-03-04
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SPACARRAYPROCESS_H
#define SPACARRAYPROCESS_H

#include "ArrayProcess.h"
#include "SPACParameters.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

class ARRAYCORE_EXPORT SPACArrayProcess : public ArrayProcess
{
public:
  SPACArrayProcess(const ArrayStations& array);

  inline bool setParameters( const SPACParameters * param, bool doNSampleWarning = true );
  inline const SPACParameters * parameters() const;
};

inline const SPACParameters * SPACArrayProcess::parameters() const
{
  return static_cast<const SPACParameters *>(ArrayProcess::parameters());
}

inline bool SPACArrayProcess::setParameters( const SPACParameters * param, bool doNSampleWarning )
{
  return ArrayProcess::setParameters(param, doNSampleWarning);
}

} // namespace ArrayCore

#endif // SPACARRAYPROCESS_H
