/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-05-14
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SPACPARAMETERS_H
#define SPACPARAMETERS_H

#include "ArrayParameters.h"
#include "RingCouples.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

class StationCouple;

class ARRAYCORE_EXPORT SPACParameters : public ArrayParameters
{
  TRANSLATIONS("SPACParameters")
public:
  enum OutputType { NoOutput=0x0, Target=0x1, Stmap=0x2, Max=0x4 };
  Q_DECLARE_FLAGS(OutputTypes, OutputType)

  void addRing( const QVector<StationCouple>& couples, double minRadius, double maxRadius );
  int ringCount() const { return _rings.count(); }
  const RingCouples& ring( int index ) const { return _rings.at(index); }

  bool overWrite(int nComponents);
  OutputTypes outputTypes() const { return _outputTypes; }
  void setOutputTypes( OutputTypes t ) { _outputTypes = t; }
private:
  QList<RingCouples> _rings;
  OutputTypes _outputTypes;
};

} // namespace ArrayCore

Q_DECLARE_OPERATORS_FOR_FLAGS(ArrayCore::SPACParameters::OutputTypes)

#endif // SPACPARAMETERS_H
