/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2004-09-06
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef StationCouple_H
#define StationCouple_H

#include <GeopsyCore.h>
#include <QGpCoreTools.h>
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

class ARRAYCORE_EXPORT StationCouple
{
public:
  StationCouple();

  void operator=( const StationCouple& o );

  void setStations(StationSignals * s1, StationSignals * s2);

  double distance() const { return _distance; }
  const Angle& azimuth() const { return _azimuth; }
  QString name() const { return (_s1->name()+"-")+_s2->name(); }
  const StationSignals * station1() const { return _s1; }
  const StationSignals * station2() const { return _s2; }
private:
  StationSignals * _s1;
  StationSignals * _s2;

  // Distance and azimuth of station couple
  double _distance;
  Angle _azimuth;
};

#if 0
  void setStations(StationProcessSignals * s1, StationProcessSignals * s2);
  double r() const {return _r;}
  double phi() const {return _phi.radians();}
  QString name() const {return (_s1->originalSignals()->name()+"-")+_s2->originalSignals()->name();}
  const StationProcessSignals * station1() const {return _s1;}
  const StationProcessSignals * station2() const {return _s2;}


  double verticalAutocorr() const;
  void splitRadialTransverse();
  double radialAutocorr() const { return _radialAutocorr; }
  double transverseAutocorr() const { return _transverseAutocorr; }
  double radialPower() const { return _radialPower; }
  double transversePower() const { return _transversePower; }
  void crossCorr(Signal * resSig);
protected:
  StationProcessSignals * _s1;
  StationProcessSignals * _s2;
  // Distance and azimuth of station couple
  double _r;
  Angle _phi;
  // For delayed ring normalization
  double _radialPower;
  double _transversePower;
  double _radialAutocorr;
  double _transverseAutocorr;
};
#endif

} // namespace ArrayCore

#endif // STATIONCOUPLE_H
