/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-03-04
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef STATIONCOUPLEPROCESS_H
#define STATIONCOUPLEPROCESS_H

#include <GeopsyCore.h>

#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

class StationCouple;

class ARRAYCORE_EXPORT StationCoupleProcess
{
public:
  StationCoupleProcess();

  void setStations( const StationCouple * cp, QList<StationProcessSignals *> stations );
  void setAzimuth( const Angle& a ) { _azimuth = a; }
  void setWeight( double w ) { _weight = w; }

  double verticalAutocorr() const;
  void horizontalAutocorr();

  double radialAutocorr() const { return _radialAutocorr*_weight; }
  double transverseAutocorr() const { return _transverseAutocorr*_weight; }
  double radialPower() const { return _radialPower*_weight; }
  double transversePower() const { return _transversePower*_weight; }
private:
  StationProcessSignals * _s1;
  StationProcessSignals * _s2;
  Angle _azimuth;
  double _weight;

  double _radialPower;
  double _transversePower;
  double _radialAutocorr;
  double _transverseAutocorr;
};

} // namespace ArrayCore

#endif // STATIONCOUPLEPROCESS_H
