/***************************************************************************
**
**  This file is part of ArrayGui.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2004-05-26
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ArrayResponse_H
#define ArrayResponse_H

#include <ArrayCore.h>
#include <QGpGuiWave.h>

#include "WaveNumAnimate.h"
#include "ArrayGuiDLLExport.h"

namespace ArrayGui {

class ARRAYGUI_EXPORT ArrayResponse : public GraphicSheetMenu
{
  Q_OBJECT
public:
  ArrayResponse(QWidget * parent=0, Qt::WFlags fl=0);
  ~ArrayResponse();

  void setArray(const QVector<Point2D>& p, double f=0.0); // Remove this option in next major release
  void setFrequencySampling(Sampling& fparam);
  void createObjects(bool showDispersion);
  double kmin() const;
  double kmax() const;
public slots:
  void setKmin(double kmin);
  void setKmax(double kmax);
  void setAzimuth(double azimuth);
private slots:
  void setTemporaryKmax();
  void setComputedKmax();
signals:
  void kminChanged(double kmin);
  void kmaxChanged(double kmin);
private:
  void initKmax(double kmax);
  void uniquePoints();
  void shiftStations();
  double theoreticalKmax() const;
  double gridKmax() const;
  double gridKmin() const;
  void scanAzimuth();
  virtual void resizeEvent(QResizeEvent *);

  LiveGridLayer * _gridLayer;
  CircleViewer * _circleLayer;
  LineLayer * _directionLayer;
  XUniqueYColorLines * _crossGrayLayer;
  LineLayer * _midHeightLayer;
  LineLayer * _crossBlackLayer;
  DispersionLimitLayer * _dispLimitLayer;

  double _kmin;
  QTimer _kmaxTimer;
  bool _kmaxTouched;
  KmaxSolver * _kmaxSolver;
  TextEdit * _comments;

  WaveNumAnimate waveNum;
  ColorPaletteWidget _palette;
  QVector<Point2D> _stations;
  QVector<Complex> _stationSig;
};

} // namespace ArrayGui

#endif // ARRAYRESPONSE_H
