/***************************************************************************
**
**  This file is part of DinverCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-02-26
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ABSTRACTCONDITION_H
#define ABSTRACTCONDITION_H

#include <QGpCoreTools.h>
#include "DinverCoreDLLExport.h"

namespace DinverCore {

class Parameter;

class DINVERCORE_EXPORT AbstractCondition : public XMLClass
{
public:
  enum Type {LessThan, GreaterThan};

  virtual bool operator==( const AbstractCondition& o ) const;

  virtual const QString& xml_tagName() const { return xmlAbstractConditionTag;}
  static const QString xmlAbstractConditionTag;

  virtual void getLimits( int parameterIndex, double& min, double& max) const = 0;
  virtual void humanInfo() const = 0;
  uint checksum() const;
  int indexOf( Parameter * p ) const { return _paramList.indexOf(p); }
  virtual bool adjustRanges() { return false; }
protected:
  Parameter& parameter( int index ) { return *_paramList.at(index); }
  const Parameter& parameter( int index ) const { return *_paramList.at(index); }
  void addParameter( Parameter * p ) { _paramList.append(p); }
  int count() const { return _paramList.count(); }

  QList<Parameter *>& parameterList() { return _paramList; }
  virtual uint internalChecksum() const = 0;
  virtual void xml_writeProperties( XML_WRITEPROPERTIES_ARGS ) const;
  virtual XMLMember xml_member( XML_MEMBER_ARGS );
  virtual bool xml_setProperty( XML_SETPROPERTY_ARGS );
private:
  QList<Parameter *> _paramList;
  QStringList _paramNameList;
};

} // namespace DinverCore

#endif // ABSTRACTCONDITION_H
