/***************************************************************************
**
**  This file is part of DinverCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-05-11
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ABSTRACTFORWARDTHREAD_H
#define ABSTRACTFORWARDTHREAD_H

#include <QGpCoreTools.h>
#include "AbstractForward.h"
#include "DinverCoreDLLExport.h"

namespace DinverCore {

class DINVERCORE_EXPORT AbstractForwardThread : public Thread, public AbstractForward
{
public:
  AbstractForwardThread( QObject * parent = 0 );
  ~AbstractForwardThread();

  virtual bool generate( int parentActiveIndex );
  virtual double misfit( bool& ok ) { return AbstractForward::misfit(ok); }

  virtual void redirectStream();
  virtual int maximumThreadCount() const { return RAND_MAX; }
  virtual bool wake();
  virtual void sleep();
private:
  virtual void run();

  bool _terminated;
  QWaitCondition _accepting;
  QMutex _acceptingMutex;
};

} // namespace DinverCore

#endif // ABSTRACTFORWARDTHREAD_H
