/***************************************************************************
**
**  This file is part of DinverCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-03-23
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ACTIVEMODEL_H
#define ACTIVEMODEL_H

#include <QGpCoreTools.h>
#include "DinverCoreDLLExport.h"

namespace DinverCore {

class DINVERCORE_EXPORT ActiveModel
{
  TRANSLATIONS("ActiveModel")
public:
  inline void operator=( int modelIndex );
  inline void operator=( const ActiveModel& o );

  int modelIndex() const { return _modelIndex; }

  int acceptedCount() const { return _nAccepted; }
  void addAccepted() { _nAccepted++; }

  int rejectedCount() const { return _nRejected; }
  void addRejected() { _nRejected++; }

  bool quarantine() const { return _quarantine; }
  void setQuarantine() { _quarantine = true; }

  inline bool giveUp( double ratio ) const;

  int navigatorHitCount() const { return _nNavigatorHits; }
  inline void addNavigatorHit();

  bool alive() const { return _lives>0; }
  inline void setAlive() ;
private:
  int _modelIndex;
  int _nAccepted;
  int _nRejected;
  int _nNavigatorHits;
  int _lives;
  bool _quarantine;
};

inline void ActiveModel::operator=( int modelIndex )
{
  _modelIndex = modelIndex;
  _nAccepted = 0;
  _nRejected = 0;
  _nNavigatorHits = 0;
  _lives = 20;
  _quarantine = false;
}

inline void ActiveModel::operator=( const ActiveModel& o )
{
  _modelIndex = o._modelIndex;
  _nAccepted = o._nAccepted;
  _nRejected = o._nRejected;
  _nNavigatorHits = o._nNavigatorHits;
  _lives = o._lives;
  _quarantine = o._quarantine;
}

inline void ActiveModel::setAlive()
{
  // Negative navigator hit count are always considered as alive.
  if ( _nNavigatorHits > 0 ) {
    _nNavigatorHits = 0;
    _lives++;
  } else if ( _nNavigatorHits == 0 ) {
     if ( alive() ) _lives--;
  }
}

inline void ActiveModel::addNavigatorHit()
{
   // During simulation only: when no model is removed
  /*if ( ! alive() ) {
    App::stream() << tr("Back to life") << endl;
    _lives++;
  }*/
  _nNavigatorHits++;
}

inline bool ActiveModel::giveUp( double ratio ) const
{
  return _nRejected > 50 &&
         _nRejected > ratio * (double)( _nRejected + _nAccepted );
}

} // namespace DinverCore

#endif // ACTIVEMODEL_H
