/***************************************************************************
**
**  This file is part of DinverCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-05-13
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ACTIVEMODELS_H
#define ACTIVEMODELS_H

//#include <GpCoreTools.h>
#include "DinverCoreDLLExport.h"
#include "ModelSet.h"
#include "ActiveModel.h"

namespace DinverCore {

class DINVERCORE_EXPORT ActiveModels : private IncreaseStorage
{
public:
  ActiveModels( ModelSet * models );
  ~ActiveModels();

  inline void add( int modelIndex );
  inline void add( const ActiveModel& m );
  void clear();
  void addNavigatorHits( const QVector<int>& activeIndexes );

  void reserve( int n ) { IncreaseStorage::reserve( n ); }
  int count() const { return IncreaseStorage::size(); }
  int parameterCount() const {return _models->parameterCount();}
  int targetCount() const {return _models->targetCount();}

  ActiveModel& at( int activeIndex ) { return _infos[ activeIndex ]; }
  const ActiveModel& at( int activeIndex ) const { return _infos[ activeIndex ]; }

  const double * misfit(int activeIndex) const {return _models->misfit(_infos[ activeIndex ].modelIndex());}
  const int * model(int activeIndex) const {return _models->model(_infos[ activeIndex ].modelIndex()); }

  void print( int activeIndex );
private:
  virtual void reallocate();

  ModelSet * _models;
  ActiveModel * _infos;
};

inline void ActiveModels::add( int modelIndex )
{
  _infos[ size() ] = modelIndex;
  IncreaseStorage::add();
}

inline void ActiveModels::add( const ActiveModel& m )
{
  _infos[ size() ] = m;
  IncreaseStorage::add();
}

} // namespace DinverCore

#endif // ACTIVEMODELS_H
