/***************************************************************************
**
**  This file is part of DinverCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-06-13
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef BATCHRUN_H
#define BATCHRUN_H

#include <QGpCoreTools.h>
#include "TemporaryDirectory.h"
#include "Neighborhood.h"
#include "ReportWriter.h"
#include "DinverCoreDLLExport.h"

namespace DinverCore {

class DinverInterface;

class DINVERCORE_EXPORT BatchRun : public QObject, private XMLClass
{
  Q_OBJECT
public:
  BatchRun( QObject * parent=0 );
  ~BatchRun();

  bool setParameters(const QString& paramFile);
  bool setTargets(const QString& targetFile);
  bool optimization(int itmax, int ns0, int ns, int nr, int seed,
                    QString fileName, ReportWriter::Action reportAction);
  bool importanceSampling(int ns, int seed, QString baseFileName,
                          QString fileName, ReportWriter::Action reportAction);
private:
  AbstractForward * createForward();
  // Mainly to maintain a pid file and signal termination
  TemporaryDirectory _tempDir;
};

} // namespace DinverCore

#endif // BATCHRUN_H
