/***************************************************************************
**
**  This file is part of DinverCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-05-06
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef BESTMODELS_H
#define BESTMODELS_H

#include "DinverCoreDLLExport.h"
#include "ActiveModels.h"

namespace DinverCore {

class DINVERCORE_EXPORT BestModels : private IncreaseStorage
{
public:
  BestModels( ActiveModels * models );
  BestModels( const BestModels& o );
  ~BestModels();

  void print();

  void setModels(ActiveModels * models) {_models=models;}
  void setNr(int nr);
  void update(int modelCount);
  void add(int modelIndex);
  void setIndex(int bestIndex, int modelIndex) {_indexes[bestIndex]=modelIndex;}
  void remove(int modelIndex);
  void clear();

  void reserve(int n) {IncreaseStorage::reserve(n);}
  int nr() const { return size(); }
  int modelIndex(int bestIndex) const { return _indexes[ bestIndex ]; }
  const double * misfit(int bestIndex) const {return _models->misfit(_indexes[bestIndex]);}
  const int * model(int bestIndex) const {return _models->model(_indexes[bestIndex]);}
private:
  friend class GridModels;

  virtual void reallocate();
  int indexOf( double m ) const;
  int exactIndexOf( int modelIndex, double m, int approxIndex ) const;
  inline void add();

  ActiveModels * _models;
  int * _indexes;
  int _nrMax, _nr2;
};

inline void BestModels::add()
{
  IncreaseStorage::add();
  while( _nr2<size() ) _nr2 = _nr2 << 1;
}

} // namespace DinverCore

#endif // BESTMODELS_H
