/***************************************************************************
**
**  This file is part of DinverCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-05-18
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef DINVERC_H
#define DINVERC_H

#ifdef __cplusplus
#include "AbstractForwardThread.h"
#include "DinverInterface.h"

namespace DinverCore {

extern "C" {
class AbstractForward;
#else
typedef void AbstractForward;
#endif

typedef AbstractForward * DinverForward;

const char * dinver_plugin_tag();
const char * dinver_plugin_title();
const char * dinver_plugin_version();
const char * dinver_plugin_description();

void dinver_init_global();
void dinver_init_run( DinverForward run );
void dinver_forward( int nd, float * model, int * ok, float * misfit );

void dinver_set_parameter_count( DinverForward forward, int n );
void dinver_set_range( DinverForward forward, int paramIndex, float min, float max, int scale, float precision );
void dinver_add_less_than_condition( DinverForward forward, int p1Index, float a, int p2Index, float b);
void dinver_add_greater_than_condition( DinverForward forward, int p1Index, float a, int p2Index, float b);

#ifdef __cplusplus
}
#endif

} // namespace DinverCore

#endif // DINVERC_H
