/***************************************************************************
**
**  This file is part of DinverCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2005-11-05
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef DINVERCOREOBJECT_H
#define DINVERCOREOBJECT_H

#include <QGpCoreTools.h>

#include "DinverCoreDLLExport.h"

namespace DinverCore {

class DinverInterface;

class DINVERCORE_EXPORT DinverCoreObject : public GlobalObject
{
  TRANSLATIONS("DinverCoreObject")
public:
  DinverCoreObject();
  virtual ~DinverCoreObject();

  virtual void addWindow(QWidget * w);
  virtual void showWindow(QWidget * w);
  virtual void removeWindow(QWidget * w);
  virtual QStringList selectedReports( const QString& title ) const;

  virtual bool useProgress() { return false; }
  virtual void setProgressMaximum(int) {}
  virtual int progressMaximum() {return 0;}
  virtual void setProgressValue(int) {}
  virtual AbstractProgress * progress() { return 0; }
  virtual void showMessage( QString ) {}

  bool isModified() const { return _modified; }
  void setModified(bool m) { _modified=m; }

  bool setPlugin( QString pluginFile, bool debug );
  DinverInterface * plugin() const {return _plugin;}

  static DinverInterface * loadPlugin( QString pluginFile, bool debug );
  static void printPluginList();
  static QStringList defaultPluginPaths();
  static QString pluginFile( QString tag, bool debug );
private:
  bool _modified;
  DinverInterface * _plugin;
};

DINVERCORE_EXPORT extern DinverCoreObject * dinverCore;

} // namespace Dinvercore

#endif // DINVERCOREOBJECT_H
