/***************************************************************************
**
**  This file is part of DinverCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2005-11-05
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef DINVERINTERFACE_H
#define DINVERINTERFACE_H

#include <QGpCoreTools.h>
#include "DinverCoreDLLExport.h"
#include "DinverCoreVersion.h"

class QMenu;

namespace DinverCore {

class AbstractForward;

class DINVERCORE_EXPORT DinverInterface : public QObject
{
  Q_OBJECT
public:
  virtual ~DinverInterface() {}

  virtual QString tag() const = 0 ;
  virtual QString title() const = 0 ;
  virtual QString version() const = 0 ;
  virtual QString description() const;

  virtual QWidget * createTargetWidget();
  virtual QWidget * createParamWidget();

  virtual void addFileMenu( QMenu * m );
  virtual void addViewMenu( QMenu * m );
  virtual void clear();

  virtual bool xmlSupport() const {return false;}
  virtual void xml_writeChildren( XML_WRITECHILDREN_ARGS ) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
  virtual bool xml_polishChild( XML_POLISHCHILD_ARGS );

  virtual AbstractForward * createForward()=0;
  virtual bool initForward(AbstractForward * /*forward*/) {return true;}
  virtual void setCurrentForward( AbstractForward * /*forwards*/, const QString& /*caption*/ ) {}

  bool isValid() const;
  virtual const char * interfaceVersion() const = 0 ;
};

} // namespace DinverCore

Q_DECLARE_INTERFACE( DinverCore::DinverInterface, "org.geopsy.dinverInterface/1.0" );

#endif // DINVERINTERFACE_H
