/***************************************************************************
**
**  This file is part of DinverCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-05-21
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef FORWARDSIGNAL_H
#define FORWARDSIGNAL_H

#include <QtCore>

namespace DinverCore {

class AbstractForward;

class ForwardSignal
{
public:
  ForwardSignal() { _forward = 0; }
  ~ForwardSignal() {}

  void lock() { _mutex.lock(); }
  void unlock() { _mutex.unlock(); }
  inline AbstractForward * wait();
  inline void finished( AbstractForward * f );
private:
  QWaitCondition _condition;
  QMutex _mutex;
  AbstractForward * _forward;
};

AbstractForward * ForwardSignal::wait()
{
  _condition.wait( &_mutex );
  AbstractForward * f = _forward;
  _forward = 0;
  _mutex.unlock();
  return f;
}

inline void ForwardSignal::finished( AbstractForward * f )
{
  _mutex.lock();
  _forward = f;
  _condition.wakeOne();
  _mutex.unlock();
}


} // namespace DinverCore

#endif // FORWARDSIGNAL_H
