/***************************************************************************
**
**  This file is part of DinverCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-06-16
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef IMPORTANCESAMPLING_H
#define IMPORTANCESAMPLING_H

#include <QGpCoreTools.h>
#include "DinverCoreDLLExport.h"

namespace DinverCore {

class AbstractForward;
class ModelSet;
class UniqueRandom;
class ReportWriter;

class DINVERCORE_EXPORT ImportanceSampling
{
  TRANSLATIONS("ImportanceSampling")
public:
  ImportanceSampling();
  ~ImportanceSampling();

  bool openReport(const QString& fileName);
  void setSeed(int seed);
  void setForward(AbstractForward * forward);
  bool importModels(QString fileName, bool strict = true);
  void generate(int ns = 5000, int nw = 2);
private:
  double * scales() const;

  uint _parameterSpaceChecksum;

  ModelSet * _models;
  AbstractForward * _forward;
  UniqueRandom * _randomGenerator;
  ReportWriter * _report;
};

} // namespace DinverCore

#endif // IMPORTANCESAMPLING_H
