/***************************************************************************
**
**  This file is part of DinverCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-05-12
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MODEL_H
#define MODEL_H

#include "DinverCoreDLLExport.h"
#include "ModelSet.h"

namespace DinverCore {

class DINVERCORE_EXPORT Model
{
public:
  inline Model( int index, ModelSet * parent );
  inline Model( const Model& o );

  bool operator==( const Model& o ) const;

  int parameterCount() const { return _parent->parameterCount(); }
  const int * data() const { return _parent->model( _index ); }
  int value( int index ) const { return data()[index]; }

  void print() const;
  static void print( int parameterCount, const int * data );
private:
  int _index;
  ModelSet * _parent;
};

uint qHash( const Model& m );

inline Model::Model( int index, ModelSet * parent )
{
  _index = index;
  _parent = parent;
}

inline Model::Model( const Model& o )
{
  _index = o._index;
  _parent = o._parent;
}


} // namespace DinverCore

#endif // MODEL_H
