/***************************************************************************
**
**  This file is part of DinverCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2004-10-21
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PARAMCONDITION_H
#define PARAMCONDITION_H

#include "AbstractCondition.h"
#include "DinverCoreDLLExport.h"

namespace DinverCore {

class DINVERCORE_EXPORT ParamCondition
{
public:
  ParamCondition();
  ParamCondition(AbstractCondition * c, int paramIndex);
  ParamCondition(const ParamCondition& c);

  inline void getLimits( double& min, double& max) const;
  void humanInfo() const { _condition->humanInfo(); }
  uint checksum() const { return _condition->checksum(); }
private:
  AbstractCondition * _condition;
  int _paramIndex;
};

inline void ParamCondition::getLimits( double& min, double& max) const
{
  TRACE;
  _condition->getLimits(_paramIndex, min, max);
}

} // namespace DinverCore

#endif // PARAMCONDITION_H
