/***************************************************************************
**
**  This file is part of DinverCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-04-10
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PARAMSPACESCRIPT_H
#define PARAMSPACESCRIPT_H

#include <QGpCoreTools.h>
#include "DinverCoreDLLExport.h"

namespace DinverCore {

class RealSpace;

class DINVERCORE_EXPORT ParamSpaceScript : public XMLClass
{
  TRANSLATIONS("ParamSpaceScript")
public:
  ParamSpaceScript() {}
  ParamSpaceScript( const ParamSpaceScript& o ) : XMLClass() { _text = o._text; }

  virtual const QString& xml_tagName() const {return xmlParamSpaceScriptTag;}
  static const QString xmlParamSpaceScriptTag;

  void setText( QString t ) { _text = t; }
  QString text() const { return _text; }

  bool apply( RealSpace * param );
protected:
  virtual void xml_writeProperties( XML_WRITEPROPERTIES_ARGS ) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
  virtual bool xml_setProperty(XML_SETPROPERTY_ARGS);
private:
  QString _text;
};

class DINVERCORE_EXPORT ParamExpressionContext : public ExpressionContext
{
  TRANSLATIONS("ParamExpressionFunctions")
public:
  ParamExpressionContext( RealSpace * param ) { _param = param; }

  virtual QStringList functions() const;
  virtual bool isValidFunction(const QString& name) const;
  virtual QVariant functionValue(const QString& name, const QVector<ExpressionAction *>& args) const;
private:
  RealSpace * _param;
};

} // namespace DinverCore

#endif // PARAMSPACESCRIPT_H
