/***************************************************************************
**
**  This file is part of DinverCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-04-11
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PDFCURVE_H
#define PDFCURVE_H

#include <QGpCoreTools.h>
#include "UniqueRandom.h"
#include "ModelSet.h"
#include "DinverCoreDLLExport.h"

namespace DinverCore {

class Parameter;

class DINVERCORE_EXPORT PdfPoint
{
public:
  PdfPoint() {_x=0.0; _cell = -1;}
  PdfPoint(double x, int cell) {_x=x; _cell=cell;}

  double x() const {return _x;}
  int cell() const {return _cell;}
  inline double probability(const ModelSet& models) const;

  static void setDegreesOfFreedom(double dof) {_degreesOfFreedom=dof;}
private:
  double _x;
  int _cell;
  static double _degreesOfFreedom;
};

class DINVERCORE_EXPORT PdfCurve : public Curve<PdfPoint>
{
public:
  double randomValue( UniqueRandom& generator, const ModelSet& models, int& cellIndex);
  void toStream(QTextStream& s, const ModelSet& models);
  void printCumulative(const ModelSet& models, const Parameter& p);
};

inline double PdfPoint::probability(const ModelSet& models) const
{
  double m=models.misfit(_cell)[0];
  return exp(-0.5*_degreesOfFreedom*m*m);
  // Old definition: abandonned on May 12 2015
  //return exp(-0.5*_degreesOfFreedom*models.misfit(_cell)[0]);
  //return models.misfit(_cell);
}

} // namespace DinverCore

#endif // PDFCURVE_H
