/***************************************************************************
**
**  This file is part of DinverCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-05-17
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SCALEDMODELS_H
#define SCALEDMODELS_H

#include "DinverCoreDLLExport.h"

namespace DinverCore {

class ActiveModels;
class ModelSet;

class DINVERCORE_EXPORT ScaledModels
{
public:
  ScaledModels( ActiveModels * m, int parameterCount, double * scales );
  ScaledModels( ModelSet * m, int parameterCount, double * scales );
  ~ScaledModels();

  int modelCount() const { return _modelCount; }
  int parameterCount() const { return _parameterCount; }

  double scale( int parameterIndex ) const { return _scales[parameterIndex]; }
  const double * v( int parameterIndex ) const { return _v[parameterIndex]; }
  const double * v2( int parameterIndex ) const { return _v2[parameterIndex]; }
private:
  int _parameterCount, _modelCount;
  double ** _v;
  double ** _v2;
  double * _scales;
};

} // namespace DinverCore

#endif // SCALEDMODELS_H
