/***************************************************************************
**
**  This file is part of DinverCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-02-26
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SIMPLECONDITION_H
#define SIMPLECONDITION_H

#include "AbstractCondition.h"
#include "DinverCoreDLLExport.h"

namespace DinverCore {

class DINVERCORE_EXPORT SimpleCondition : public AbstractCondition
{
public:
  SimpleCondition( Parameter * p1, Type type, double factor, Parameter * p2, double constant );
  virtual bool operator==( const AbstractCondition& o ) const;

  virtual const QString& xml_tagName() const { return xmlSimpleConditionTag;}
  static const QString xmlSimpleConditionTag;

  inline virtual void getLimits( int paramIndex, double& min, double& max) const;
  virtual bool adjustRanges();
  virtual void humanInfo() const;
protected:
  virtual uint internalChecksum() const;
  virtual void xml_writeProperties( XML_WRITEPROPERTIES_ARGS ) const;
  virtual XMLMember xml_member( XML_MEMBER_ARGS );
  virtual bool xml_setProperty( XML_SETPROPERTY_ARGS );
private:
  Type _type;
  double _factor;
  double _constant;
};

} // namespace DinverCore

#include "Parameter.h"

namespace DinverCore {

inline void SimpleCondition::getLimits( int paramIndex, double& min, double& max) const
{
  TRACE;
  double threshold;
  switch (paramIndex) {
  case 0:
    threshold = _factor * parameter(1).realValue() + _constant;
    switch ( _type ) {
    case LessThan:
      if ( threshold < max ) {
        max = threshold;
      }
      break;
    case GreaterThan:
      if ( threshold > min ) {
        min = threshold;
      }
      break;
    }
    break;
  default:
    threshold = parameter(0).realValue() - _constant;
    switch ( _type ) {
    case LessThan:
      if ( threshold > _factor * min ) {
        if (_factor == 1.0 )
          min = threshold;
        else
          min = threshold / _factor;
      }
      break;
    case GreaterThan:
      if ( threshold < _factor * max ) {
        if (_factor == 1.0 )
          max = threshold;
        else
          max = threshold / _factor;
      }
      break;
    }
    break;
  }
}

} // namespace DinverCore

#endif // SIMPLECONDITION_H
