/***************************************************************************
**
**  This file is part of DinverCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-04-21
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef TEMPORARYDIRECTORY_H
#define TEMPORARYDIRECTORY_H

#include <QtCore>
#include "DinverCoreDLLExport.h"

namespace DinverCore {

class DINVERCORE_EXPORT TemporaryDirectory : public QObject, private QDir
{
  Q_OBJECT
public:
  TemporaryDirectory( QObject * parent=0 );
  ~TemporaryDirectory();

  QString absolutePath() const { return QDir::absolutePath(); }
private slots:
  void keepAlive();
private:
  void setPath( QString p );
  void clear();

  QTimer _keepAlive;
};

} // namespace DinverCore

#endif // TEMPORARYDIRECTORY_H
