/***************************************************************************
**
**  This file is part of DinverCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-05-20
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef UNIQUERANDOM_H
#define UNIQUERANDOM_H

#include <QGpCoreTools.h>
#include "DinverCoreDLLExport.h"

namespace DinverCore {

class DINVERCORE_EXPORT UniqueRandom : private Random
{
public:
  UniqueRandom( int seed ) : Random( seed ) {}
  ~UniqueRandom() {}

  inline double uniform();
  inline double uniform( double min, double max );
  inline int uniform( int min, int max );
private:
  QMutex _mutex;
};

inline double UniqueRandom::uniform()
{
  QMutexLocker ml (&_mutex);
  return Random::ran2();
}

inline double UniqueRandom::uniform( double min, double max )
{
  QMutexLocker ml (&_mutex);
  return Random::uniform( min, max );
}

inline int UniqueRandom::uniform( int min, int max )
{
  QMutexLocker ml (&_mutex);
  return Random::uniform( min, max );
}

} // namespace DinverCore

#endif // UNIQUERANDOM_H
