/***************************************************************************
**
**  This file is part of DinverCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-06-06
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef XMLDINVERCONTEXT_H
#define XMLDINVERCONTEXT_H

#include <QGpCoreTools.h>
#include "DinverCoreDLLExport.h"

namespace DinverCore {

class DINVERCORE_EXPORT XMLDinverContext : public XMLContext
{
public:
  enum FileType{Targets=1, Parameters=2,  All=3};

  XMLDinverContext(FileType ft) {_fileType=ft;}
  ~XMLDinverContext() {}

  bool all() const {return targets() && parameters();}
  bool targets() const {return _fileType & Targets;}
  bool parameters() const {return _fileType & Parameters;}
private:
  FileType _fileType;
};

} // namespace DinverCore

#endif // XMLDINVERCONTEXT_H
