/***************************************************************************
**
**  This file is part of DinverDCCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-07-27
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef AUTOCORRTARGET_H
#define AUTOCORRTARGET_H

#include <QGpCoreWave.h>
#include "Target.h"
#include "DinverDCCoreDLLExport.h"

namespace DinverDCCore {

class DINVERDCCORE_EXPORT AutocorrTarget : public Target
{
public:
  AutocorrTarget();
  AutocorrTarget(const AutocorrTarget& o);

  virtual const QString& xml_tagName() const {return xmlAutocorrTargetTag;}
  static const QString xmlAutocorrTargetTag;

  const AutocorrCurves& curves() const { return _curves;}
  AutocorrCurves& curves() { return _curves;}
  void setCurves(const AutocorrCurves& c);
protected:
  virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
  virtual void xml_polish(XML_POLISH_ARGS);
private:
  AutocorrCurves _curves;
};

} // namespace DinverDCCore

#endif // AUTOCORRTARGET_H
