/***************************************************************************
**
**  This file is part of DinverDCCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2006-05-17
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef DCMODELINFO_H
#define DCMODELINFO_H

#include <DinverCore.h>
#include <QGpCoreTools.h>
#include "DinverDCCoreDLLExport.h"

namespace DinverDCCore {

class DINVERDCCORE_EXPORT DCModelInfo : public SharedObject
{
public:
  DCModelInfo() {_report=0;_samples=0;}
  ~DCModelInfo()
  {
    ReportReader::removeReference( _report );
    delete [] _samples;
  }

  void setCurveCount( int n ) { delete [] _samples; if(n>0) _samples=new Curve[n]; else _samples=0; }

  void setReport(ReportReader * r) {_report=r;_report->addReference();}
  void setIndexInReport(int i) {_indexInReport=i;}
  void setMisfit(double m) {_misfit=m;}
  void setOffset( int curveIndex, int offset ) {_samples[ curveIndex ].offset = offset;}
  void setSampleCount( int curveIndex, int nSamples ) {_samples[ curveIndex ].nSamples = nSamples;}

  ReportReader * report() const { return _report;}
  int indexInReport() const { return _indexInReport;}
  double misfit() const { return _misfit;}
  int offset( int curveIndex ) const { return _samples[ curveIndex ].offset;}
  int sampleCount( int curveIndex ) const { return _samples[ curveIndex ].nSamples;}

  // The sign is reversed to sort by decreasing misfit
  static bool misfitLessThan( const DCModelInfo * i1, const DCModelInfo * i2 )
  {
    /* When dealing with minimum misfit reports, there are a lot of models
       with the same misfit. Hence this is condition does not ensure a unique
       order of a list of models. The model index is added to have a unique order. */
    if(i1->_misfit>i2->_misfit) return true;
    else if (i1->_misfit<i2->_misfit) return false;
    else {
      if(i1->_indexInReport<i2->_indexInReport) return true;
      else return false;
    }
  }
  static bool loadLessThan( const DCModelInfo * i1, const DCModelInfo * i2 )
  {
    if ( i1->_report < i2->_report ) return true;
    else if ( i1->_report > i2->_report ) return false;
    else {
      if ( i1->_indexInReport < i2->_indexInReport ) return true;
      else return false;
    }
  }
private:
  ReportReader * _report;
  int _indexInReport;
  double _misfit;
  struct Curve {
    int nSamples, offset;
  };
  Curve * _samples;
};

} // namespace DinverDCCore

#endif // DCMODELINFO_H
