/***************************************************************************
**
**  This file is part of DinverDCCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-08-09
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GROUNDPARAMETER_H
#define GROUNDPARAMETER_H

#include <DinverCore.h>
#include "DinverDCCoreDLLExport.h"

namespace DinverDCCore {

class ParamLayer;

class DINVERDCCORE_EXPORT GroundParameter : public Parameter
{
public:
  enum Type { ValueTop, ValueBottom, Depth, Thickness, LeftDepth, LeftThickness, RightDepth, RightThickness };

  GroundParameter( const ParamLayer * layer, Type type, double min, double max );

  void addLayer( const ParamLayer * layer ) { _layers << layer; }
  const ParamLayer * layer(int index) const { return _layers.at(index); }
  int count() const { return _layers.count(); }
  Type type() const { return _type; }
private:
  QList<const ParamLayer *> _layers;
  Type _type;
};

} // namespace DinverDCCore

#endif // GROUNDPARAMETER_H
