/***************************************************************************
**
**  This file is part of DinverDCCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-07-27
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MODALCURVETARGET_H
#define MODALCURVETARGET_H

#include <QGpCoreWave.h>
#include "Target.h"
#include "DinverDCCoreDLLExport.h"

namespace DinverDCCore {

class DINVERDCCORE_EXPORT ModalCurveTarget : public Target
{
public:
  ModalCurveTarget();
  ModalCurveTarget(const ModalCurveTarget& o);

  virtual const QString& xml_tagName() const {return xmlModalCurveTargetTag;}
  static const QString xmlModalCurveTargetTag;

  const QList<ModalCurve>& curves() const {return _curves;}
  QList<ModalCurve>& curves() {return _curves;}
  void setCurves(const QList<ModalCurve>& c);
protected:
  virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
private:
  QList<ModalCurve> _curves;
};

} // namespace DinverDCCore

#endif // MODALCURVETARGET_H
