/***************************************************************************
**
**  This file is part of DinverDCCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2006-05-19
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MODALSTORAGEREADER_H
#define MODALSTORAGEREADER_H

#include "DinverDCCoreDLLExport.h"

namespace DinverDCCore {

class DINVERDCCORE_EXPORT ModalStorageReader
{
public:
  ModalStorageReader(QDataStream& s);

  int nModes() {return _nModes;}
  bool seek(QDataStream& s, int iMode);
  void setBetaReleaseOffsets(QDataStream& s, bool rayleigh);

  void toPlot(QDataStream& s, Point2D * points) const;
  void toStream( QDataStream& s, QTextStream& sOut ) const;
  void toStream( QDataStream& s, QDataStream& sOut ) const;
protected:
  int _nModes;
  QList<qint64> _offsets;
};

} // namespace DinverDCCore

#endif // MODALSTORAGEREADER_H
